/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware;

import jace.apple2e.RAM128k;
import jace.config.ConfigurableField;
import jace.config.Name;
import jace.core.Computer;
import jace.core.PagedMemory;
import jace.core.RAMEvent;
import jace.core.RAMListener;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

@Name(value="Ramworks III Memory Expansion")
public class CardRamworks
extends RAM128k {
    public static int BANK_SELECT = 49267;
    public int currentBank = 0;
    public Map<BankType, PagedMemory> nullBank = this.generateBank();
    @ConfigurableField(category="memory", defaultValue="3072", name="Memory Size", description="Size in KB.  Should be a multiple of 64 and not exceed 8192.  The real card cannot support more than 3072k")
    public int memorySize = 3072;
    public int maxBank = this.memorySize / 64;
    int[] pageOrder = new int[]{0, 4, 8, 12, 1, 2, 3, 5, 6, 7, 9, 10, 11, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 48, 49, 50, 51, 52, 53, 54, 55, 80, 81, 82, 83, 84, 85, 86, 87, 112, 113, 114, 115, 116, 117, 118, 119, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 120, 121, 122, 123, 124, 125, 126, 127};
    public List<Map<BankType, PagedMemory>> memory;
    PagedMemory lastAux = null;
    RAMListener bankSelectListener = new RAMListener(RAMEvent.TYPE.WRITE, RAMEvent.SCOPE.ADDRESS, RAMEvent.VALUE.ANY){

        @Override
        protected void doConfig() {
            this.setScopeStart(BANK_SELECT);
            this.setScopeEnd(BANK_SELECT);
        }

        @Override
        protected void doEvent(RAMEvent e) {
            CardRamworks.this.currentBank = e.getNewValue();
            CardRamworks.this.configureActiveMemory();
        }
    };

    private Map<BankType, PagedMemory> generateBank() {
        EnumMap<BankType, PagedMemory> memoryBank = new EnumMap<BankType, PagedMemory>(BankType.class);
        memoryBank.put(BankType.MAIN_MEMORY, new PagedMemory(49152, PagedMemory.Type.ram));
        memoryBank.put(BankType.LANGUAGE_CARD_1, new PagedMemory(12288, PagedMemory.Type.languageCard));
        memoryBank.put(BankType.LANGUAGE_CARD_2, new PagedMemory(4096, PagedMemory.Type.languageCard));
        return memoryBank;
    }

    public CardRamworks() {
        this.memory = new ArrayList<Map<BankType, PagedMemory>>(this.maxBank);
        this.reconfigure();
    }

    private PagedMemory getAuxBank(BankType type, int bank) {
        if (bank >= this.maxBank) {
            return this.nullBank.get((Object)type);
        }
        Map<BankType, PagedMemory> memoryBank = this.memory.get(bank);
        if (memoryBank == null) {
            memoryBank = this.generateBank();
            this.memory.set(bank, memoryBank);
        }
        return memoryBank.get((Object)type);
    }

    @Override
    public PagedMemory getAuxVideoMemory() {
        return this.getAuxBank(BankType.MAIN_MEMORY, 0);
    }

    @Override
    public PagedMemory getAuxMemory() {
        return this.getAuxBank(BankType.MAIN_MEMORY, this.currentBank);
    }

    @Override
    public PagedMemory getAuxLanguageCard() {
        return this.getAuxBank(BankType.LANGUAGE_CARD_1, this.currentBank);
    }

    @Override
    public PagedMemory getAuxLanguageCard2() {
        return this.getAuxBank(BankType.LANGUAGE_CARD_2, this.currentBank);
    }

    @Override
    public String getName() {
        return "Ramworks III";
    }

    @Override
    public String getShortName() {
        return "Ramworks3";
    }

    @Override
    public void reconfigure() {
        boolean resume = Computer.pause();
        this.maxBank = this.memorySize / 64;
        if (this.maxBank < 1) {
            this.maxBank = 1;
        }
        if (this.maxBank > 128) {
            this.maxBank = 128;
        }
        for (int i = this.memory.size(); i < this.maxBank; ++i) {
            this.memory.add(null);
        }
        this.configureActiveMemory();
        if (resume) {
            Computer.resume();
        }
    }

    @Override
    public void attach() {
        this.addListener(this.bankSelectListener);
    }

    @Override
    public void detach() {
        this.removeListener(this.bankSelectListener);
    }

    public static enum BankType {
        MAIN_MEMORY,
        LANGUAGE_CARD_1,
        LANGUAGE_CARD_2;

    }
}

